<?php

namespace VM\ApiBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use FOS\RestBundle\Controller\Annotations\View;
use VM\ApiBundle\Entity\CompanyAllegroCategoryItem;
use VM\ApiBundle\Entity\CompanyReport;

class RoundReportsController extends AbstractController
{
    /**
     * @View(serializerGroups={"list"})
     */
    public function getRoundReportsAction()
    {
        $User = $this->getUser();
        $Company = $this->getApiGetter()->getUserCompanyOrFalse($User);

        $response = array(
            'simpleReports' => array(),
            'extendedReports' => array(),
        );

        /**
         * @var CompanyReport $CompanyReport
         */
        foreach($Company->getRoundReports() as $CompanyReport)
        {
            if($CompanyReport->getExtended())
            {
                $response['extendedReports'][] = $CompanyReport;
            }
            else
            {
                $response['simpleReports'][] = $CompanyReport;
            }
        }

        return $response;
    }

}
